/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;

public class FiniteReader
extends PushbackReader {
    protected int readLimit;
    protected int numberRead = 0;

    public FiniteReader(Reader reader, int n) {
        super(reader);
        this.readLimit = n;
    }

    public FiniteReader(Reader reader, int n, int n2) {
        super(reader, n);
        this.readLimit = n2;
    }

    public String toString() {
        return "FiniteReader [ " + this.numberRead + " / " + this.readLimit + " ] on " + this.in;
    }

    public void close() throws IOException {
    }

    public int read() throws IOException {
        if (this.numberRead >= this.readLimit) {
            return -1;
        }
        ++this.numberRead;
        int n = this.in.read();
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.numberRead >= this.readLimit) {
            return -1;
        }
        int n3 = Math.min(n2, this.readLimit - this.numberRead);
        int n4 = this.in.read(cArray, n, n2);
        if (n4 > 0) {
            this.numberRead += n4;
        }
        return n4;
    }

    public void unread(int n) throws IOException {
        --this.numberRead;
        super.unread(n);
    }

    public void unread(char[] cArray, int n, int n2) throws IOException {
        this.numberRead -= n2;
        super.unread(cArray, n, n2);
    }
}

